package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisableAddressTransferRequest(allocationId: AllocationId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest = {
    import DisableAddressTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly =
    zio.aws.ec2.model.DisableAddressTransferRequest.wrap(buildAwsValue())
}
object DisableAddressTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableAddressTransferRequest =
      zio.aws.ec2.model.DisableAddressTransferRequest(allocationId)
    def allocationId: AllocationId
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ) extends zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableAddressTransferRequest
  ): zio.aws.ec2.model.DisableAddressTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
