package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumeStatusResponse(
    nextToken: Optional[String] = Optional.Absent,
    volumeStatuses: Optional[Iterable[zio.aws.ec2.model.VolumeStatusItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse = {
    import DescribeVolumeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        volumeStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumeStatuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVolumeStatusResponse.wrap(buildAwsValue())
}
object DescribeVolumeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumeStatusResponse =
      zio.aws.ec2.model.DescribeVolumeStatusResponse(
        nextToken.map(value => value),
        volumeStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def volumeStatuses
        : Optional[List[zio.aws.ec2.model.VolumeStatusItem.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVolumeStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusItem.ReadOnly
    ]] = AwsError.unwrapOptionField("volumeStatuses", volumeStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse
  ) extends zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val volumeStatuses
        : Optional[List[zio.aws.ec2.model.VolumeStatusItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VolumeStatusItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse
  ): zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly = new Wrapper(impl)
}
