package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessInstanceLoggingConfigurationsResponse(
    loggingConfigurations: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse = {
    import DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
      .builder()
      .optionallyWith(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loggingConfigurations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessInstanceLoggingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse =
      zio.aws.ec2.model
        .DescribeVerifiedAccessInstanceLoggingConfigurationsResponse(
          loggingConfigurations.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def loggingConfigurations: Optional[List[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getLoggingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("loggingConfigurations", loggingConfigurations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.ReadOnly {
    override val loggingConfigurations: Optional[List[
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse
  ): zio.aws.ec2.model.DescribeVerifiedAccessInstanceLoggingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
