package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTrafficMirrorSessionsResponse(
    trafficMirrorSessions: Optional[
      Iterable[zio.aws.ec2.model.TrafficMirrorSession]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse = {
    import DescribeTrafficMirrorSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse
      .builder()
      .optionallyWith(
        trafficMirrorSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.trafficMirrorSessions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse
      .wrap(buildAwsValue())
}
object DescribeTrafficMirrorSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse =
      zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse(
        trafficMirrorSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def trafficMirrorSessions
        : Optional[List[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]]
    def nextToken: Optional[String]
    def getTrafficMirrorSessions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("trafficMirrorSessions", trafficMirrorSessions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse
  ) extends zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly {
    override val trafficMirrorSessions
        : Optional[List[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorSession.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTrafficMirrorSessionsResponse
  ): zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly =
    new Wrapper(impl)
}
