package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeManagedPrefixListsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    prefixLists: Optional[Iterable[zio.aws.ec2.model.ManagedPrefixList]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse = {
    import DescribeManagedPrefixListsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        prefixLists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixLists)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeManagedPrefixListsResponse.wrap(buildAwsValue())
}
object DescribeManagedPrefixListsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeManagedPrefixListsResponse =
      zio.aws.ec2.model.DescribeManagedPrefixListsResponse(
        nextToken.map(value => value),
        prefixLists.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def prefixLists
        : Optional[List[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrefixLists: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ManagedPrefixList.ReadOnly
    ]] = AwsError.unwrapOptionField("prefixLists", prefixLists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ) extends zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val prefixLists
        : Optional[List[zio.aws.ec2.model.ManagedPrefixList.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixLists())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ManagedPrefixList.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeManagedPrefixListsResponse
  ): zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly =
    new Wrapper(impl)
}
