package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAddressTransfersResponse(
    addressTransfers: Optional[Iterable[zio.aws.ec2.model.AddressTransfer]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse = {
    import DescribeAddressTransfersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse
      .builder()
      .optionallyWith(
        addressTransfers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addressTransfers)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAddressTransfersResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAddressTransfersResponse.wrap(buildAwsValue())
}
object DescribeAddressTransfersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAddressTransfersResponse =
      zio.aws.ec2.model.DescribeAddressTransfersResponse(
        addressTransfers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def addressTransfers
        : Optional[List[zio.aws.ec2.model.AddressTransfer.ReadOnly]]
    def nextToken: Optional[String]
    def getAddressTransfers
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AddressTransfer.ReadOnly]] =
      AwsError.unwrapOptionField("addressTransfers", addressTransfers)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse
  ) extends zio.aws.ec2.model.DescribeAddressTransfersResponse.ReadOnly {
    override val addressTransfers
        : Optional[List[zio.aws.ec2.model.AddressTransfer.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressTransfers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddressTransfer.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAddressTransfersResponse
  ): zio.aws.ec2.model.DescribeAddressTransfersResponse.ReadOnly = new Wrapper(
    impl
  )
}
