package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.RouteTableId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteRouteTableRequest(routeTableId: RouteTableId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest = {
    import DeleteRouteTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
      .builder()
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly =
    zio.aws.ec2.model.DeleteRouteTableRequest.wrap(buildAwsValue())
}
object DeleteRouteTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteRouteTableRequest =
      zio.aws.ec2.model.DeleteRouteTableRequest(routeTableId)
    def routeTableId: RouteTableId
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ) extends zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly {
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteRouteTableRequest
  ): zio.aws.ec2.model.DeleteRouteTableRequest.ReadOnly = new Wrapper(impl)
}
