package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAccessScopeResponse(
    networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse = {
    import DeleteNetworkInsightsAccessScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse
      .wrap(buildAwsValue())
}
object DeleteNetworkInsightsAccessScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse =
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse(
        networkInsightsAccessScopeId.map(value => value)
      )
    def networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly {
    override val networkInsightsAccessScopeId
        : Optional[NetworkInsightsAccessScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAccessScopeResponse
  ): zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly =
    new Wrapper(impl)
}
