package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteIpamResourceDiscoveryResponse(
    ipamResourceDiscovery: Optional[zio.aws.ec2.model.IpamResourceDiscovery] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse = {
    import DeleteIpamResourceDiscoveryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse
      .builder()
      .optionallyWith(
        ipamResourceDiscovery.map(value => value.buildAwsValue())
      )(_.ipamResourceDiscovery)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse.ReadOnly =
    zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse.wrap(buildAwsValue())
}
object DeleteIpamResourceDiscoveryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse =
      zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse(
        ipamResourceDiscovery.map(value => value.asEditable)
      )
    def ipamResourceDiscovery
        : Optional[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly]
    def getIpamResourceDiscovery
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly] =
      AwsError.unwrapOptionField("ipamResourceDiscovery", ipamResourceDiscovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse
  ) extends zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse.ReadOnly {
    override val ipamResourceDiscovery
        : Optional[zio.aws.ec2.model.IpamResourceDiscovery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamResourceDiscovery())
        .map(value => zio.aws.ec2.model.IpamResourceDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryResponse
  ): zio.aws.ec2.model.DeleteIpamResourceDiscoveryResponse.ReadOnly =
    new Wrapper(impl)
}
