package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamResourceDiscoveryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIpamResourceDiscoveryRequest(
    ipamResourceDiscoveryId: IpamResourceDiscoveryId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest = {
    import DeleteIpamResourceDiscoveryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
      .builder()
      .ipamResourceDiscoveryId(
        IpamResourceDiscoveryId.unwrap(
          ipamResourceDiscoveryId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.wrap(buildAwsValue())
}
object DeleteIpamResourceDiscoveryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest =
      zio.aws.ec2.model
        .DeleteIpamResourceDiscoveryRequest(ipamResourceDiscoveryId)
    def ipamResourceDiscoveryId: IpamResourceDiscoveryId
    def getIpamResourceDiscoveryId: ZIO[Any, Nothing, IpamResourceDiscoveryId] =
      ZIO.succeed(ipamResourceDiscoveryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ) extends zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly {
    override val ipamResourceDiscoveryId: IpamResourceDiscoveryId =
      zio.aws.ec2.model.primitives
        .IpamResourceDiscoveryId(impl.ipamResourceDiscoveryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamResourceDiscoveryRequest
  ): zio.aws.ec2.model.DeleteIpamResourceDiscoveryRequest.ReadOnly =
    new Wrapper(impl)
}
