package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcEndpointId, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointConnectionNotificationRequest(
    serviceId: Optional[VpcEndpointServiceId] = Optional.Absent,
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    connectionNotificationArn: String,
    connectionEvents: Iterable[String],
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest = {
    import CreateVpcEndpointConnectionNotificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest
      .builder()
      .optionallyWith(
        serviceId.map(value =>
          VpcEndpointServiceId.unwrap(value): java.lang.String
        )
      )(_.serviceId)
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .connectionNotificationArn(connectionNotificationArn: java.lang.String)
      .connectionEvents(connectionEvents.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest
      .wrap(buildAwsValue())
}
object CreateVpcEndpointConnectionNotificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest =
      zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest(
        serviceId.map(value => value),
        vpcEndpointId.map(value => value),
        connectionNotificationArn,
        connectionEvents,
        clientToken.map(value => value)
      )
    def serviceId: Optional[VpcEndpointServiceId]
    def vpcEndpointId: Optional[VpcEndpointId]
    def connectionNotificationArn: String
    def connectionEvents: List[String]
    def clientToken: Optional[String]
    def getServiceId: ZIO[Any, AwsError, VpcEndpointServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getConnectionNotificationArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(connectionNotificationArn)
    def getConnectionEvents: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(connectionEvents)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest
  ) extends zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest.ReadOnly {
    override val serviceId: Optional[VpcEndpointServiceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceId())
        .map(value => zio.aws.ec2.model.primitives.VpcEndpointServiceId(value))
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.ec2.model.primitives.VpcEndpointId(value))
    override val connectionNotificationArn: String =
      impl.connectionNotificationArn(): String
    override val connectionEvents: List[String] = impl
      .connectionEvents()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointConnectionNotificationRequest
  ): zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest.ReadOnly =
    new Wrapper(impl)
}
