package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  VerifiedAccessEndpointPortNumber,
  NetworkInterfaceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessEndpointEniOptions(
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      Optional.Absent,
    port: Optional[VerifiedAccessEndpointPortNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions = {
    import CreateVerifiedAccessEndpointEniOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions
      .builder()
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        port.map(value =>
          VerifiedAccessEndpointPortNumber.unwrap(value): Integer
        )
      )(_.port)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions
      .wrap(buildAwsValue())
}
object CreateVerifiedAccessEndpointEniOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions =
      zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions(
        networkInterfaceId.map(value => value),
        protocol.map(value => value),
        port.map(value => value)
      )
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol]
    def port: Optional[VerifiedAccessEndpointPortNumber]
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, VerifiedAccessEndpointPortNumber] =
      AwsError.unwrapOptionField("port", port)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions
  ) extends zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly {
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val protocol
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointProtocol.wrap(value)
        )
    override val port: Optional[VerifiedAccessEndpointPortNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.port())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessEndpointPortNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointEniOptions
  ): zio.aws.ec2.model.CreateVerifiedAccessEndpointEniOptions.ReadOnly =
    new Wrapper(impl)
}
