package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFleetResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.ec2.model.CreateFleetError]] =
      Optional.Absent,
    instances: Optional[Iterable[zio.aws.ec2.model.CreateFleetInstance]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFleetResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFleetResponse.ReadOnly =
    zio.aws.ec2.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFleetResponse =
      zio.aws.ec2.model.CreateFleetResponse(
        fleetId.map(value => value),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetId: Optional[FleetId]
    def errors: Optional[List[zio.aws.ec2.model.CreateFleetError.ReadOnly]]
    def instances
        : Optional[List[zio.aws.ec2.model.CreateFleetInstance.ReadOnly]]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CreateFleetError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CreateFleetInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetResponse
  ) extends zio.aws.ec2.model.CreateFleetResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
    override val errors
        : Optional[List[zio.aws.ec2.model.CreateFleetError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CreateFleetError.wrap(item)
          }.toList
        )
    override val instances
        : Optional[List[zio.aws.ec2.model.CreateFleetInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CreateFleetInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFleetResponse
  ): zio.aws.ec2.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
