package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelImageLaunchPermissionRequest(imageId: ImageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest = {
    import CancelImageLaunchPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelImageLaunchPermissionRequest.ReadOnly =
    zio.aws.ec2.model.CancelImageLaunchPermissionRequest.wrap(buildAwsValue())
}
object CancelImageLaunchPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelImageLaunchPermissionRequest =
      zio.aws.ec2.model.CancelImageLaunchPermissionRequest(imageId)
    def imageId: ImageId
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest
  ) extends zio.aws.ec2.model.CancelImageLaunchPermissionRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelImageLaunchPermissionRequest
  ): zio.aws.ec2.model.CancelImageLaunchPermissionRequest.ReadOnly =
    new Wrapper(impl)
}
