package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BundleTaskError(
    code: Optional[String] = Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.BundleTaskError = {
    import BundleTaskError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.BundleTaskError
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.BundleTaskError.ReadOnly =
    zio.aws.ec2.model.BundleTaskError.wrap(buildAwsValue())
}
object BundleTaskError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.BundleTaskError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.BundleTaskError = zio.aws.ec2.model
      .BundleTaskError(code.map(value => value), message.map(value => value))
    def code: Optional[String]
    def message: Optional[String]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.BundleTaskError
  ) extends zio.aws.ec2.model.BundleTaskError.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.BundleTaskError
  ): zio.aws.ec2.model.BundleTaskError.ReadOnly = new Wrapper(impl)
}
