package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ArchitectureValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.ArchitectureValues
}
object ArchitectureValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ArchitectureValues
  ): zio.aws.ec2.model.ArchitectureValues = value match {
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.I386 =>
      val r = i386
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.X86_64 =>
      val r = x86_64
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.ARM64 =>
      val r = arm64
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.X86_64_MAC =>
      val r = x86_64_mac
      r
    case software.amazon.awssdk.services.ec2.model.ArchitectureValues.ARM64_MAC =>
      val r = arm64_mac
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.UNKNOWN_TO_SDK_VERSION
  }
  case object i386 extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.I386
  }
  case object x86_64 extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.X86_64
  }
  case object arm64 extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.ARM64
  }
  case object x86_64_mac extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.X86_64_MAC
  }
  case object arm64_mac extends zio.aws.ec2.model.ArchitectureValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ArchitectureValues =
      software.amazon.awssdk.services.ec2.model.ArchitectureValues.ARM64_MAC
  }
}
