package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddPrefixListEntry(
    cidr: String,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AddPrefixListEntry = {
    import AddPrefixListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AddPrefixListEntry
      .builder()
      .cidr(cidr: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AddPrefixListEntry.ReadOnly =
    zio.aws.ec2.model.AddPrefixListEntry.wrap(buildAwsValue())
}
object AddPrefixListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AddPrefixListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AddPrefixListEntry = zio.aws.ec2.model
      .AddPrefixListEntry(cidr, description.map(value => value))
    def cidr: String
    def description: Optional[String]
    def getCidr: ZIO[Any, Nothing, String] = ZIO.succeed(cidr)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AddPrefixListEntry
  ) extends zio.aws.ec2.model.AddPrefixListEntry.ReadOnly {
    override val cidr: String = impl.cidr(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AddPrefixListEntry
  ): zio.aws.ec2.model.AddPrefixListEntry.ReadOnly = new Wrapper(impl)
}
