package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogDeliveryStatus(
    code: Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatusCode] =
      Optional.Absent,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus = {
    import VerifiedAccessLogDeliveryStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus
      .builder()
      .optionallyWith(code.map(value => value.unwrap))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.wrap(buildAwsValue())
}
object VerifiedAccessLogDeliveryStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus =
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus(
        code.map(value => value),
        message.map(value => value)
      )
    def code: Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatusCode]
    def message: Optional[String]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogDeliveryStatusCode
    ] = AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus
  ) extends zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly {
    override val code
        : Optional[zio.aws.ec2.model.VerifiedAccessLogDeliveryStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.code())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessLogDeliveryStatusCode.wrap(value)
        )
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogDeliveryStatus
  ): zio.aws.ec2.model.VerifiedAccessLogDeliveryStatus.ReadOnly = new Wrapper(
    impl
  )
}
