package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VerifiedAccessEndpointType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType
}
object VerifiedAccessEndpointType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType
  ): zio.aws.ec2.model.VerifiedAccessEndpointType = value match {
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.LOAD_BALANCER =>
      val r = `load-balancer`
      r
    case software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.NETWORK_INTERFACE =>
      val r = `network-interface`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VerifiedAccessEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object `load-balancer`
      extends zio.aws.ec2.model.VerifiedAccessEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.LOAD_BALANCER
  }
  case object `network-interface`
      extends zio.aws.ec2.model.VerifiedAccessEndpointType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType =
      software.amazon.awssdk.services.ec2.model.VerifiedAccessEndpointType.NETWORK_INTERFACE
  }
}
