package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayPolicyTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPolicyTableAssociation(
    transitGatewayPolicyTableId: Optional[TransitGatewayPolicyTableId] =
      Optional.Absent,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    resourceId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.TransitGatewayAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation = {
    import TransitGatewayPolicyTableAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation
      .builder()
      .optionallyWith(
        transitGatewayPolicyTableId.map(value =>
          TransitGatewayPolicyTableId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayPolicyTableId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.wrap(buildAwsValue())
}
object TransitGatewayPolicyTableAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPolicyTableAssociation =
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation(
        transitGatewayPolicyTableId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        state.map(value => value)
      )
    def transitGatewayPolicyTableId: Optional[TransitGatewayPolicyTableId]
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def resourceId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def state: Optional[zio.aws.ec2.model.TransitGatewayAssociationState]
    def getTransitGatewayPolicyTableId
        : ZIO[Any, AwsError, TransitGatewayPolicyTableId] =
      AwsError.unwrapOptionField(
        "transitGatewayPolicyTableId",
        transitGatewayPolicyTableId
      )
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAssociationState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation
  ) extends zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly {
    override val transitGatewayPolicyTableId
        : Optional[TransitGatewayPolicyTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPolicyTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayPolicyTableId(value)
      )
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
    override val state
        : Optional[zio.aws.ec2.model.TransitGatewayAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTableAssociation
  ): zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly =
    new Wrapper(impl)
}
