package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetNetwork(
    associationId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    targetNetworkId: Optional[String] = Optional.Absent,
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.AssociationStatus] = Optional.Absent,
    securityGroups: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TargetNetwork = {
    import TargetNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetNetwork
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(targetNetworkId.map(value => value: java.lang.String))(
        _.targetNetworkId
      )
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetNetwork.ReadOnly =
    zio.aws.ec2.model.TargetNetwork.wrap(buildAwsValue())
}
object TargetNetwork {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.TargetNetwork] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetNetwork =
      zio.aws.ec2.model.TargetNetwork(
        associationId.map(value => value),
        vpcId.map(value => value),
        targetNetworkId.map(value => value),
        clientVpnEndpointId.map(value => value),
        status.map(value => value.asEditable),
        securityGroups.map(value => value)
      )
    def associationId: Optional[String]
    def vpcId: Optional[String]
    def targetNetworkId: Optional[String]
    def clientVpnEndpointId: Optional[String]
    def status: Optional[zio.aws.ec2.model.AssociationStatus.ReadOnly]
    def securityGroups: Optional[List[String]]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getTargetNetworkId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetNetworkId", targetNetworkId)
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetNetwork
  ) extends zio.aws.ec2.model.TargetNetwork.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val targetNetworkId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetNetworkId())
      .map(value => value: String)
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AssociationStatus.wrap(value))
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetNetwork
  ): zio.aws.ec2.model.TargetNetwork.ReadOnly = new Wrapper(impl)
}
