package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SuccessfulInstanceCreditSpecificationItem(
    instanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem = {
    import SuccessfulInstanceCreditSpecificationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly =
    zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem
      .wrap(buildAwsValue())
}
object SuccessfulInstanceCreditSpecificationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem =
      zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem(
        instanceId.map(value => value)
      )
    def instanceId: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem
  ) extends zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SuccessfulInstanceCreditSpecificationItem
  ): zio.aws.ec2.model.SuccessfulInstanceCreditSpecificationItem.ReadOnly =
    new Wrapper(impl)
}
