package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SpotInstanceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.SpotInstanceType
}
object SpotInstanceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SpotInstanceType
  ): zio.aws.ec2.model.SpotInstanceType = value match {
    case software.amazon.awssdk.services.ec2.model.SpotInstanceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceType.ONE_TIME =>
      val r = `one-time`
      r
    case software.amazon.awssdk.services.ec2.model.SpotInstanceType.PERSISTENT =>
      val r = persistent
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SpotInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceType =
      software.amazon.awssdk.services.ec2.model.SpotInstanceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `one-time` extends zio.aws.ec2.model.SpotInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceType =
      software.amazon.awssdk.services.ec2.model.SpotInstanceType.ONE_TIME
  }
  case object persistent extends zio.aws.ec2.model.SpotInstanceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.SpotInstanceType =
      software.amazon.awssdk.services.ec2.model.SpotInstanceType.PERSISTENT
  }
}
