package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteTableAssociation(
    main: Optional[Boolean] = Optional.Absent,
    routeTableAssociationId: Optional[String] = Optional.Absent,
    routeTableId: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    gatewayId: Optional[String] = Optional.Absent,
    associationState: Optional[zio.aws.ec2.model.RouteTableAssociationState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RouteTableAssociation = {
    import RouteTableAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RouteTableAssociation
      .builder()
      .optionallyWith(main.map(value => value: java.lang.Boolean))(_.main)
      .optionallyWith(
        routeTableAssociationId.map(value => value: java.lang.String)
      )(_.routeTableAssociationId)
      .optionallyWith(routeTableId.map(value => value: java.lang.String))(
        _.routeTableId
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(gatewayId.map(value => value: java.lang.String))(
        _.gatewayId
      )
      .optionallyWith(associationState.map(value => value.buildAwsValue()))(
        _.associationState
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RouteTableAssociation.ReadOnly =
    zio.aws.ec2.model.RouteTableAssociation.wrap(buildAwsValue())
}
object RouteTableAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RouteTableAssociation =
      zio.aws.ec2.model.RouteTableAssociation(
        main.map(value => value),
        routeTableAssociationId.map(value => value),
        routeTableId.map(value => value),
        subnetId.map(value => value),
        gatewayId.map(value => value),
        associationState.map(value => value.asEditable)
      )
    def main: Optional[Boolean]
    def routeTableAssociationId: Optional[String]
    def routeTableId: Optional[String]
    def subnetId: Optional[String]
    def gatewayId: Optional[String]
    def associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly]
    def getMain: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("main", main)
    def getRouteTableAssociationId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("routeTableAssociationId", routeTableAssociationId)
    def getRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("routeTableId", routeTableId)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("gatewayId", gatewayId)
    def getAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RouteTableAssociationState.ReadOnly
    ] = AwsError.unwrapOptionField("associationState", associationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ) extends zio.aws.ec2.model.RouteTableAssociation.ReadOnly {
    override val main: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.main())
      .map(value => value: Boolean)
    override val routeTableAssociationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableAssociationId())
        .map(value => value: String)
    override val routeTableId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.routeTableId())
      .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val gatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayId())
      .map(value => value: String)
    override val associationState
        : Optional[zio.aws.ec2.model.RouteTableAssociationState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationState())
        .map(value => zio.aws.ec2.model.RouteTableAssociationState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RouteTableAssociation
  ): zio.aws.ec2.model.RouteTableAssociation.ReadOnly = new Wrapper(impl)
}
