package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublicIpv4PoolRange(
    firstAddress: Optional[String] = Optional.Absent,
    lastAddress: Optional[String] = Optional.Absent,
    addressCount: Optional[Integer] = Optional.Absent,
    availableAddressCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange = {
    import PublicIpv4PoolRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
      .builder()
      .optionallyWith(firstAddress.map(value => value: java.lang.String))(
        _.firstAddress
      )
      .optionallyWith(lastAddress.map(value => value: java.lang.String))(
        _.lastAddress
      )
      .optionallyWith(addressCount.map(value => value: java.lang.Integer))(
        _.addressCount
      )
      .optionallyWith(
        availableAddressCount.map(value => value: java.lang.Integer)
      )(_.availableAddressCount)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly =
    zio.aws.ec2.model.PublicIpv4PoolRange.wrap(buildAwsValue())
}
object PublicIpv4PoolRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PublicIpv4PoolRange =
      zio.aws.ec2.model.PublicIpv4PoolRange(
        firstAddress.map(value => value),
        lastAddress.map(value => value),
        addressCount.map(value => value),
        availableAddressCount.map(value => value)
      )
    def firstAddress: Optional[String]
    def lastAddress: Optional[String]
    def addressCount: Optional[Integer]
    def availableAddressCount: Optional[Integer]
    def getFirstAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("firstAddress", firstAddress)
    def getLastAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastAddress", lastAddress)
    def getAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("addressCount", addressCount)
    def getAvailableAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableAddressCount", availableAddressCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ) extends zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly {
    override val firstAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.firstAddress())
      .map(value => value: String)
    override val lastAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastAddress())
      .map(value => value: String)
    override val addressCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.addressCount())
      .map(value => value: Integer)
    override val availableAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableAddressCount())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PublicIpv4PoolRange
  ): zio.aws.ec2.model.PublicIpv4PoolRange.ReadOnly = new Wrapper(impl)
}
