package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.ec2.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Protocol
  ): zio.aws.ec2.model.Protocol = value match {
    case software.amazon.awssdk.services.ec2.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Protocol.TCP =>
      val r = tcp
      r
    case software.amazon.awssdk.services.ec2.model.Protocol.UDP =>
      val r = udp
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Protocol =
      software.amazon.awssdk.services.ec2.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object tcp extends zio.aws.ec2.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Protocol =
      software.amazon.awssdk.services.ec2.model.Protocol.TCP
  }
  case object udp extends zio.aws.ec2.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.ec2.model.Protocol =
      software.amazon.awssdk.services.ec2.model.Protocol.UDP
  }
}
