package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class NatGateway(
    createTime: Optional[DateTime] = Optional.Absent,
    deleteTime: Optional[DateTime] = Optional.Absent,
    failureCode: Optional[String] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    natGatewayAddresses: Optional[
      Iterable[zio.aws.ec2.model.NatGatewayAddress]
    ] = Optional.Absent,
    natGatewayId: Optional[String] = Optional.Absent,
    provisionedBandwidth: Optional[zio.aws.ec2.model.ProvisionedBandwidth] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.NatGatewayState] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    connectivityType: Optional[zio.aws.ec2.model.ConnectivityType] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NatGateway = {
    import NatGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NatGateway
      .builder()
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(deleteTime.map(value => DateTime.unwrap(value): Instant))(
        _.deleteTime
      )
      .optionallyWith(failureCode.map(value => value: java.lang.String))(
        _.failureCode
      )
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(
        natGatewayAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.natGatewayAddresses)
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .optionallyWith(provisionedBandwidth.map(value => value.buildAwsValue()))(
        _.provisionedBandwidth
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(connectivityType.map(value => value.unwrap))(
        _.connectivityType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NatGateway.ReadOnly =
    zio.aws.ec2.model.NatGateway.wrap(buildAwsValue())
}
object NatGateway {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NatGateway] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NatGateway = zio.aws.ec2.model.NatGateway(
      createTime.map(value => value),
      deleteTime.map(value => value),
      failureCode.map(value => value),
      failureMessage.map(value => value),
      natGatewayAddresses.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      natGatewayId.map(value => value),
      provisionedBandwidth.map(value => value.asEditable),
      state.map(value => value),
      subnetId.map(value => value),
      vpcId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      connectivityType.map(value => value)
    )
    def createTime: Optional[DateTime]
    def deleteTime: Optional[DateTime]
    def failureCode: Optional[String]
    def failureMessage: Optional[String]
    def natGatewayAddresses
        : Optional[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]]
    def natGatewayId: Optional[String]
    def provisionedBandwidth
        : Optional[zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly]
    def state: Optional[zio.aws.ec2.model.NatGatewayState]
    def subnetId: Optional[String]
    def vpcId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def connectivityType: Optional[zio.aws.ec2.model.ConnectivityType]
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getDeleteTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("deleteTime", deleteTime)
    def getFailureCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getNatGatewayAddresses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NatGatewayAddress.ReadOnly
    ]] = AwsError.unwrapOptionField("natGatewayAddresses", natGatewayAddresses)
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
    def getProvisionedBandwidth
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly] =
      AwsError.unwrapOptionField("provisionedBandwidth", provisionedBandwidth)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.NatGatewayState] =
      AwsError.unwrapOptionField("state", state)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConnectivityType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectivityType] =
      AwsError.unwrapOptionField("connectivityType", connectivityType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NatGateway
  ) extends zio.aws.ec2.model.NatGateway.ReadOnly {
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val deleteTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val failureCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => value: String)
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val natGatewayAddresses
        : Optional[List[zio.aws.ec2.model.NatGatewayAddress.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.natGatewayAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NatGatewayAddress.wrap(item)
          }.toList
        )
    override val natGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => value: String)
    override val provisionedBandwidth
        : Optional[zio.aws.ec2.model.ProvisionedBandwidth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedBandwidth())
        .map(value => zio.aws.ec2.model.ProvisionedBandwidth.wrap(value))
    override val state: Optional[zio.aws.ec2.model.NatGatewayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.NatGatewayState.wrap(value))
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val connectivityType
        : Optional[zio.aws.ec2.model.ConnectivityType] = zio.aws.core.internal
      .optionalFromNullable(impl.connectivityType())
      .map(value => zio.aws.ec2.model.ConnectivityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NatGateway
  ): zio.aws.ec2.model.NatGateway.ReadOnly = new Wrapper(impl)
}
