package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessEndpointResponse(
    verifiedAccessEndpoint: Optional[zio.aws.ec2.model.VerifiedAccessEndpoint] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse = {
    import ModifyVerifiedAccessEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse
      .builder()
      .optionallyWith(
        verifiedAccessEndpoint.map(value => value.buildAwsValue())
      )(_.verifiedAccessEndpoint)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse.wrap(buildAwsValue())
}
object ModifyVerifiedAccessEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse =
      zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse(
        verifiedAccessEndpoint.map(value => value.asEditable)
      )
    def verifiedAccessEndpoint
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly]
    def getVerifiedAccessEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessEndpoint",
      verifiedAccessEndpoint
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse.ReadOnly {
    override val verifiedAccessEndpoint
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessEndpoint())
        .map(value => zio.aws.ec2.model.VerifiedAccessEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessEndpointResponse
  ): zio.aws.ec2.model.ModifyVerifiedAccessEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
