package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class IpamDiscoveredAccount(
    accountId: Optional[String] = Optional.Absent,
    discoveryRegion: Optional[String] = Optional.Absent,
    failureReason: Optional[zio.aws.ec2.model.IpamDiscoveryFailureReason] =
      Optional.Absent,
    lastAttemptedDiscoveryTime: Optional[MillisecondDateTime] = Optional.Absent,
    lastSuccessfulDiscoveryTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount = {
    import IpamDiscoveredAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(discoveryRegion.map(value => value: java.lang.String))(
        _.discoveryRegion
      )
      .optionallyWith(failureReason.map(value => value.buildAwsValue()))(
        _.failureReason
      )
      .optionallyWith(
        lastAttemptedDiscoveryTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.lastAttemptedDiscoveryTime)
      .optionallyWith(
        lastSuccessfulDiscoveryTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulDiscoveryTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly =
    zio.aws.ec2.model.IpamDiscoveredAccount.wrap(buildAwsValue())
}
object IpamDiscoveredAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamDiscoveredAccount =
      zio.aws.ec2.model.IpamDiscoveredAccount(
        accountId.map(value => value),
        discoveryRegion.map(value => value),
        failureReason.map(value => value.asEditable),
        lastAttemptedDiscoveryTime.map(value => value),
        lastSuccessfulDiscoveryTime.map(value => value)
      )
    def accountId: Optional[String]
    def discoveryRegion: Optional[String]
    def failureReason
        : Optional[zio.aws.ec2.model.IpamDiscoveryFailureReason.ReadOnly]
    def lastAttemptedDiscoveryTime: Optional[MillisecondDateTime]
    def lastSuccessfulDiscoveryTime: Optional[MillisecondDateTime]
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getDiscoveryRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("discoveryRegion", discoveryRegion)
    def getFailureReason: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamDiscoveryFailureReason.ReadOnly
    ] = AwsError.unwrapOptionField("failureReason", failureReason)
    def getLastAttemptedDiscoveryTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "lastAttemptedDiscoveryTime",
        lastAttemptedDiscoveryTime
      )
    def getLastSuccessfulDiscoveryTime
        : ZIO[Any, AwsError, MillisecondDateTime] = AwsError.unwrapOptionField(
      "lastSuccessfulDiscoveryTime",
      lastSuccessfulDiscoveryTime
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount
  ) extends zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly {
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val discoveryRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.discoveryRegion())
      .map(value => value: String)
    override val failureReason
        : Optional[zio.aws.ec2.model.IpamDiscoveryFailureReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value => zio.aws.ec2.model.IpamDiscoveryFailureReason.wrap(value))
    override val lastAttemptedDiscoveryTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedDiscoveryTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val lastSuccessfulDiscoveryTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulDiscoveryTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamDiscoveredAccount
  ): zio.aws.ec2.model.IpamDiscoveredAccount.ReadOnly = new Wrapper(impl)
}
