package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamAssociatedResourceDiscoveryStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus
}
object IpamAssociatedResourceDiscoveryStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus
  ): zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus = value match {
    case software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.NOT_FOUND =>
      val r = `not-found`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus =
      software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object active
      extends zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus =
      software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.ACTIVE
  }
  case object `not-found`
      extends zio.aws.ec2.model.IpamAssociatedResourceDiscoveryStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus =
      software.amazon.awssdk.services.ec2.model.IpamAssociatedResourceDiscoveryStatus.NOT_FOUND
  }
}
