package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpPermission(
    fromPort: Optional[Integer] = Optional.Absent,
    ipProtocol: Optional[String] = Optional.Absent,
    ipRanges: Optional[Iterable[zio.aws.ec2.model.IpRange]] = Optional.Absent,
    ipv6Ranges: Optional[Iterable[zio.aws.ec2.model.Ipv6Range]] =
      Optional.Absent,
    prefixListIds: Optional[Iterable[zio.aws.ec2.model.PrefixListId]] =
      Optional.Absent,
    toPort: Optional[Integer] = Optional.Absent,
    userIdGroupPairs: Optional[Iterable[zio.aws.ec2.model.UserIdGroupPair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IpPermission = {
    import IpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpPermission
      .builder()
      .optionallyWith(fromPort.map(value => value: java.lang.Integer))(
        _.fromPort
      )
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        ipv6Ranges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Ranges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .optionallyWith(toPort.map(value => value: java.lang.Integer))(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpPermission.ReadOnly =
    zio.aws.ec2.model.IpPermission.wrap(buildAwsValue())
}
object IpPermission {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpPermission] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpPermission =
      zio.aws.ec2.model.IpPermission(
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        ipRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ipv6Ranges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        prefixListIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromPort: Optional[Integer]
    def ipProtocol: Optional[String]
    def ipRanges: Optional[List[zio.aws.ec2.model.IpRange.ReadOnly]]
    def ipv6Ranges: Optional[List[zio.aws.ec2.model.Ipv6Range.ReadOnly]]
    def prefixListIds: Optional[List[zio.aws.ec2.model.PrefixListId.ReadOnly]]
    def toPort: Optional[Integer]
    def userIdGroupPairs
        : Optional[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getIpRanges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpRange.ReadOnly]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getIpv6Ranges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Ipv6Range.ReadOnly]] =
      AwsError.unwrapOptionField("ipv6Ranges", ipv6Ranges)
    def getPrefixListIds
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PrefixListId.ReadOnly]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpPermission
  ) extends zio.aws.ec2.model.IpPermission.ReadOnly {
    override val fromPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.fromPort())
      .map(value => value: Integer)
    override val ipProtocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipProtocol())
      .map(value => value: String)
    override val ipRanges: Optional[List[zio.aws.ec2.model.IpRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipRanges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpRange.wrap(item)
          }.toList
        )
    override val ipv6Ranges
        : Optional[List[zio.aws.ec2.model.Ipv6Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv6Ranges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Ipv6Range.wrap(item)
          }.toList
        )
    override val prefixListIds
        : Optional[List[zio.aws.ec2.model.PrefixListId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixListIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PrefixListId.wrap(item)
          }.toList
        )
    override val toPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.toPort())
      .map(value => value: Integer)
    override val userIdGroupPairs
        : Optional[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userIdGroupPairs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.UserIdGroupPair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpPermission
  ): zio.aws.ec2.model.IpPermission.ReadOnly = new Wrapper(impl)
}
