package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceMetadataEndpointState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState
}
object InstanceMetadataEndpointState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState
  ): zio.aws.ec2.model.InstanceMetadataEndpointState = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.DISABLED =>
      val r = disabled
      r
    case software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.ENABLED =>
      val r = enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.UNKNOWN_TO_SDK_VERSION
  }
  case object disabled extends zio.aws.ec2.model.InstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.DISABLED
  }
  case object enabled extends zio.aws.ec2.model.InstanceMetadataEndpointState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState =
      software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState.ENABLED
  }
}
