package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IamInstanceProfileAssociationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState
}
object IamInstanceProfileAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState
  ): zio.aws.ec2.model.IamInstanceProfileAssociationState = value match {
    case software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.DISASSOCIATING =>
      val r = disassociating
      r
    case software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.DISASSOCIATED =>
      val r = disassociated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.IamInstanceProfileAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState =
      software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object associating
      extends zio.aws.ec2.model.IamInstanceProfileAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState =
      software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.ASSOCIATING
  }
  case object associated
      extends zio.aws.ec2.model.IamInstanceProfileAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState =
      software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.ASSOCIATED
  }
  case object disassociating
      extends zio.aws.ec2.model.IamInstanceProfileAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState =
      software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.DISASSOCIATING
  }
  case object disassociated
      extends zio.aws.ec2.model.IamInstanceProfileAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState =
      software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociationState.DISASSOCIATED
  }
}
