package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetVerifiedAccessEndpointPolicyRequest(
    verifiedAccessEndpointId: VerifiedAccessEndpointId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest = {
    import GetVerifiedAccessEndpointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
      .builder()
      .verifiedAccessEndpointId(
        VerifiedAccessEndpointId.unwrap(
          verifiedAccessEndpointId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly =
    zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest
      .wrap(buildAwsValue())
}
object GetVerifiedAccessEndpointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest =
      zio.aws.ec2.model
        .GetVerifiedAccessEndpointPolicyRequest(verifiedAccessEndpointId)
    def verifiedAccessEndpointId: VerifiedAccessEndpointId
    def getVerifiedAccessEndpointId
        : ZIO[Any, Nothing, VerifiedAccessEndpointId] =
      ZIO.succeed(verifiedAccessEndpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ) extends zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly {
    override val verifiedAccessEndpointId: VerifiedAccessEndpointId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessEndpointId(impl.verifiedAccessEndpointId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetVerifiedAccessEndpointPolicyRequest
  ): zio.aws.ec2.model.GetVerifiedAccessEndpointPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
