package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayRouteTableAnnouncementId,
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableTransitGatewayRouteTablePropagationRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    transitGatewayRouteTableAnnouncementId: Optional[
      TransitGatewayRouteTableAnnouncementId
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest = {
    import DisableTransitGatewayRouteTablePropagationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        transitGatewayRouteTableAnnouncementId.map(value =>
          TransitGatewayRouteTableAnnouncementId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayRouteTableAnnouncementId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
      .wrap(buildAwsValue())
}
object DisableTransitGatewayRouteTablePropagationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest =
      zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest(
        transitGatewayRouteTableId,
        transitGatewayAttachmentId.map(value => value),
        transitGatewayRouteTableAnnouncementId.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, AwsError, TransitGatewayRouteTableAnnouncementId] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableAnnouncementId",
        transitGatewayRouteTableAnnouncementId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ) extends zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val transitGatewayRouteTableAnnouncementId
        : Optional[TransitGatewayRouteTableAnnouncementId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableAnnouncementId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .TransitGatewayRouteTableAnnouncementId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ): zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest.ReadOnly =
    new Wrapper(impl)
}
