package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessTrustProvidersResponse(
    verifiedAccessTrustProviders: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessTrustProvider]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse = {
    import DescribeVerifiedAccessTrustProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse
      .builder()
      .optionallyWith(
        verifiedAccessTrustProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verifiedAccessTrustProviders)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessTrustProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse =
      zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse(
        verifiedAccessTrustProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def verifiedAccessTrustProviders
        : Optional[List[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVerifiedAccessTrustProviders: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "verifiedAccessTrustProviders",
      verifiedAccessTrustProviders
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse.ReadOnly {
    override val verifiedAccessTrustProviders: Optional[
      List[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessTrustProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VerifiedAccessTrustProvider.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessTrustProvidersResponse
  ): zio.aws.ec2.model.DescribeVerifiedAccessTrustProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
