package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayAttachmentsResponse(
    transitGatewayAttachments: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayAttachment]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse = {
    import DescribeTransitGatewayAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse
      .builder()
      .optionallyWith(
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayAttachments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse(
        transitGatewayAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayAttachments
        : Optional[List[zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly]]
    def nextToken: Optional[String]
    def getTransitGatewayAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayAttachments",
      transitGatewayAttachments
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly {
    override val transitGatewayAttachments
        : Optional[List[zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayAttachment.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayAttachmentsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
