package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNatGatewaysResponse(
    natGateways: Optional[Iterable[zio.aws.ec2.model.NatGateway]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse = {
    import DescribeNatGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse
      .builder()
      .optionallyWith(
        natGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.natGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeNatGatewaysResponse.wrap(buildAwsValue())
}
object DescribeNatGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNatGatewaysResponse =
      zio.aws.ec2.model.DescribeNatGatewaysResponse(
        natGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def natGateways: Optional[List[zio.aws.ec2.model.NatGateway.ReadOnly]]
    def nextToken: Optional[String]
    def getNatGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NatGateway.ReadOnly]] =
      AwsError.unwrapOptionField("natGateways", natGateways)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly {
    override val natGateways
        : Optional[List[zio.aws.ec2.model.NatGateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.natGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NatGateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse
  ): zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly = new Wrapper(impl)
}
