package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewaysResponse(
    localGateways: Optional[Iterable[zio.aws.ec2.model.LocalGateway]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse = {
    import DescribeLocalGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse
      .builder()
      .optionallyWith(
        localGateways.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGateways)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewaysResponse.wrap(buildAwsValue())
}
object DescribeLocalGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLocalGatewaysResponse =
      zio.aws.ec2.model.DescribeLocalGatewaysResponse(
        localGateways.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGateways: Optional[List[zio.aws.ec2.model.LocalGateway.ReadOnly]]
    def nextToken: Optional[String]
    def getLocalGateways
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.LocalGateway.ReadOnly]] =
      AwsError.unwrapOptionField("localGateways", localGateways)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly {
    override val localGateways
        : Optional[List[zio.aws.ec2.model.LocalGateway.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localGateways())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.LocalGateway.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewaysResponse
  ): zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly = new Wrapper(
    impl
  )
}
