package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIpamResourceDiscoveryAssociationsResponse(
    ipamResourceDiscoveryAssociations: Optional[
      Iterable[zio.aws.ec2.model.IpamResourceDiscoveryAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse = {
    import DescribeIpamResourceDiscoveryAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse
      .builder()
      .optionallyWith(
        ipamResourceDiscoveryAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamResourceDiscoveryAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeIpamResourceDiscoveryAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse =
      zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse(
        ipamResourceDiscoveryAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ipamResourceDiscoveryAssociations: Optional[
      List[zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getIpamResourceDiscoveryAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "ipamResourceDiscoveryAssociations",
      ipamResourceDiscoveryAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse.ReadOnly {
    override val ipamResourceDiscoveryAssociations: Optional[
      List[zio.aws.ec2.model.IpamResourceDiscoveryAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamResourceDiscoveryAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpamResourceDiscoveryAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse
  ): zio.aws.ec2.model.DescribeIpamResourceDiscoveryAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
