package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAwsNetworkPerformanceMetricSubscriptionsResponse(
    nextToken: Optional[String] = Optional.Absent,
    subscriptions: Optional[Iterable[zio.aws.ec2.model.Subscription]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse = {
    import DescribeAwsNetworkPerformanceMetricSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse
      .wrap(buildAwsValue())
}
object DescribeAwsNetworkPerformanceMetricSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse =
      zio.aws.ec2.model
        .DescribeAwsNetworkPerformanceMetricSubscriptionsResponse(
          nextToken.map(value => value),
          subscriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[String]
    def subscriptions: Optional[List[zio.aws.ec2.model.Subscription.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSubscriptions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Subscription.ReadOnly]] =
      AwsError.unwrapOptionField("subscriptions", subscriptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse
  ) extends zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val subscriptions
        : Optional[List[zio.aws.ec2.model.Subscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Subscription.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse
  ): zio.aws.ec2.model.DescribeAwsNetworkPerformanceMetricSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
