package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorTargetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorTargetRequest(
    trafficMirrorTargetId: TrafficMirrorTargetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest = {
    import DeleteTrafficMirrorTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
      .builder()
      .trafficMirrorTargetId(
        TrafficMirrorTargetId.unwrap(trafficMirrorTargetId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest(trafficMirrorTargetId)
    def trafficMirrorTargetId: TrafficMirrorTargetId
    def getTrafficMirrorTargetId: ZIO[Any, Nothing, TrafficMirrorTargetId] =
      ZIO.succeed(trafficMirrorTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly {
    override val trafficMirrorTargetId: TrafficMirrorTargetId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorTargetId(impl.trafficMirrorTargetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
