package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CustomerGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCustomerGatewayRequest(
    customerGatewayId: CustomerGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest = {
    import DeleteCustomerGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest
      .builder()
      .customerGatewayId(
        CustomerGatewayId.unwrap(customerGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCustomerGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCustomerGatewayRequest.wrap(buildAwsValue())
}
object DeleteCustomerGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCustomerGatewayRequest =
      zio.aws.ec2.model.DeleteCustomerGatewayRequest(customerGatewayId)
    def customerGatewayId: CustomerGatewayId
    def getCustomerGatewayId: ZIO[Any, Nothing, CustomerGatewayId] =
      ZIO.succeed(customerGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest
  ) extends zio.aws.ec2.model.DeleteCustomerGatewayRequest.ReadOnly {
    override val customerGatewayId: CustomerGatewayId =
      zio.aws.ec2.model.primitives.CustomerGatewayId(impl.customerGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCustomerGatewayRequest
  ): zio.aws.ec2.model.DeleteCustomerGatewayRequest.ReadOnly = new Wrapper(impl)
}
