package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  SubnetId,
  LoadBalancerArn,
  VerifiedAccessEndpointPortNumber
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateVerifiedAccessEndpointLoadBalancerOptions(
    protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      Optional.Absent,
    port: Optional[VerifiedAccessEndpointPortNumber] = Optional.Absent,
    loadBalancerArn: Optional[LoadBalancerArn] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions = {
    import CreateVerifiedAccessEndpointLoadBalancerOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        port.map(value =>
          VerifiedAccessEndpointPortNumber.unwrap(value): Integer
        )
      )(_.port)
      .optionallyWith(
        loadBalancerArn.map(value =>
          LoadBalancerArn.unwrap(value): java.lang.String
        )
      )(_.loadBalancerArn)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly =
    zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
      .wrap(buildAwsValue())
}
object CreateVerifiedAccessEndpointLoadBalancerOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions =
      zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions(
        protocol.map(value => value),
        port.map(value => value),
        loadBalancerArn.map(value => value),
        subnetIds.map(value => value)
      )
    def protocol: Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol]
    def port: Optional[VerifiedAccessEndpointPortNumber]
    def loadBalancerArn: Optional[LoadBalancerArn]
    def subnetIds: Optional[List[SubnetId]]
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getPort: ZIO[Any, AwsError, VerifiedAccessEndpointPortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getLoadBalancerArn: ZIO[Any, AwsError, LoadBalancerArn] =
      AwsError.unwrapOptionField("loadBalancerArn", loadBalancerArn)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
  ) extends zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly {
    override val protocol
        : Optional[zio.aws.ec2.model.VerifiedAccessEndpointProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessEndpointProtocol.wrap(value)
        )
    override val port: Optional[VerifiedAccessEndpointPortNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.port())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessEndpointPortNumber(value)
        )
    override val loadBalancerArn: Optional[LoadBalancerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerArn())
        .map(value => zio.aws.ec2.model.primitives.LoadBalancerArn(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions
  ): zio.aws.ec2.model.CreateVerifiedAccessEndpointLoadBalancerOptions.ReadOnly =
    new Wrapper(impl)
}
