package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateCoipCidrResponse(
    coipCidr: Optional[zio.aws.ec2.model.CoipCidr] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse = {
    import CreateCoipCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse
      .builder()
      .optionallyWith(coipCidr.map(value => value.buildAwsValue()))(_.coipCidr)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCoipCidrResponse.ReadOnly =
    zio.aws.ec2.model.CreateCoipCidrResponse.wrap(buildAwsValue())
}
object CreateCoipCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCoipCidrResponse = zio.aws.ec2.model
      .CreateCoipCidrResponse(coipCidr.map(value => value.asEditable))
    def coipCidr: Optional[zio.aws.ec2.model.CoipCidr.ReadOnly]
    def getCoipCidr: ZIO[Any, AwsError, zio.aws.ec2.model.CoipCidr.ReadOnly] =
      AwsError.unwrapOptionField("coipCidr", coipCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse
  ) extends zio.aws.ec2.model.CreateCoipCidrResponse.ReadOnly {
    override val coipCidr: Optional[zio.aws.ec2.model.CoipCidr.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipCidr())
        .map(value => zio.aws.ec2.model.CoipCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCoipCidrResponse
  ): zio.aws.ec2.model.CreateCoipCidrResponse.ReadOnly = new Wrapper(impl)
}
