package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyFpgaImageRequest(
    sourceFpgaImageId: String,
    description: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    sourceRegion: String,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest = {
    import CopyFpgaImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest
      .builder()
      .sourceFpgaImageId(sourceFpgaImageId: java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .sourceRegion(sourceRegion: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CopyFpgaImageRequest.ReadOnly =
    zio.aws.ec2.model.CopyFpgaImageRequest.wrap(buildAwsValue())
}
object CopyFpgaImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CopyFpgaImageRequest =
      zio.aws.ec2.model.CopyFpgaImageRequest(
        sourceFpgaImageId,
        description.map(value => value),
        name.map(value => value),
        sourceRegion,
        clientToken.map(value => value)
      )
    def sourceFpgaImageId: String
    def description: Optional[String]
    def name: Optional[String]
    def sourceRegion: String
    def clientToken: Optional[String]
    def getSourceFpgaImageId: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceFpgaImageId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSourceRegion: ZIO[Any, Nothing, String] = ZIO.succeed(sourceRegion)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest
  ) extends zio.aws.ec2.model.CopyFpgaImageRequest.ReadOnly {
    override val sourceFpgaImageId: String = impl.sourceFpgaImageId(): String
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val sourceRegion: String = impl.sourceRegion(): String
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CopyFpgaImageRequest
  ): zio.aws.ec2.model.CopyFpgaImageRequest.ReadOnly = new Wrapper(impl)
}
