package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceptVpcEndpointConnectionsResponse(
    unsuccessful: Optional[Iterable[zio.aws.ec2.model.UnsuccessfulItem]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse = {
    import AcceptVpcEndpointConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse
      .builder()
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.wrap(buildAwsValue())
}
object AcceptVpcEndpointConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse =
      zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse(
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unsuccessful
        : Optional[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]]
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.UnsuccessfulItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse
  ) extends zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly {
    override val unsuccessful
        : Optional[List[zio.aws.ec2.model.UnsuccessfulItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unsuccessful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.UnsuccessfulItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsResponse
  ): zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
