package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TrafficType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TrafficType
}
object TrafficType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TrafficType
  ): zio.aws.ec2.model.TrafficType = value match {
    case software.amazon.awssdk.services.ec2.model.TrafficType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TrafficType.ACCEPT =>
      val r = ACCEPT
      r
    case software.amazon.awssdk.services.ec2.model.TrafficType.REJECT =>
      val r = REJECT
      r
    case software.amazon.awssdk.services.ec2.model.TrafficType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TrafficType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.TrafficType =
      software.amazon.awssdk.services.ec2.model.TrafficType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCEPT extends zio.aws.ec2.model.TrafficType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.TrafficType =
      software.amazon.awssdk.services.ec2.model.TrafficType.ACCEPT
  }
  case object REJECT extends zio.aws.ec2.model.TrafficType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.TrafficType =
      software.amazon.awssdk.services.ec2.model.TrafficType.REJECT
  }
  case object ALL extends zio.aws.ec2.model.TrafficType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.TrafficType =
      software.amazon.awssdk.services.ec2.model.TrafficType.ALL
  }
}
