package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServiceConfiguration(
    serviceType: Optional[Iterable[zio.aws.ec2.model.ServiceTypeDetail]] =
      Optional.Absent,
    serviceId: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    serviceState: Optional[zio.aws.ec2.model.ServiceState] = Optional.Absent,
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    acceptanceRequired: Optional[Boolean] = Optional.Absent,
    managesVpcEndpoints: Optional[Boolean] = Optional.Absent,
    networkLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    gatewayLoadBalancerArns: Optional[Iterable[String]] = Optional.Absent,
    supportedIpAddressTypes: Optional[
      Iterable[zio.aws.ec2.model.ServiceConnectivityType]
    ] = Optional.Absent,
    baseEndpointDnsNames: Optional[Iterable[String]] = Optional.Absent,
    privateDnsName: Optional[String] = Optional.Absent,
    privateDnsNameConfiguration: Optional[
      zio.aws.ec2.model.PrivateDnsNameConfiguration
    ] = Optional.Absent,
    payerResponsibility: Optional[zio.aws.ec2.model.PayerResponsibility] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ServiceConfiguration = {
    import ServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ServiceConfiguration
      .builder()
      .optionallyWith(
        serviceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceType)
      .optionallyWith(serviceId.map(value => value: java.lang.String))(
        _.serviceId
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(serviceState.map(value => value.unwrap))(_.serviceState)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(
        managesVpcEndpoints.map(value => value: java.lang.Boolean)
      )(_.managesVpcEndpoints)
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .optionallyWith(
        supportedIpAddressTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.supportedIpAddressTypesWithStrings)
      .optionallyWith(
        baseEndpointDnsNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.baseEndpointDnsNames)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        privateDnsNameConfiguration.map(value => value.buildAwsValue())
      )(_.privateDnsNameConfiguration)
      .optionallyWith(payerResponsibility.map(value => value.unwrap))(
        _.payerResponsibility
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ServiceConfiguration.ReadOnly =
    zio.aws.ec2.model.ServiceConfiguration.wrap(buildAwsValue())
}
object ServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ServiceConfiguration =
      zio.aws.ec2.model.ServiceConfiguration(
        serviceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceId.map(value => value),
        serviceName.map(value => value),
        serviceState.map(value => value),
        availabilityZones.map(value => value),
        acceptanceRequired.map(value => value),
        managesVpcEndpoints.map(value => value),
        networkLoadBalancerArns.map(value => value),
        gatewayLoadBalancerArns.map(value => value),
        supportedIpAddressTypes.map(value => value),
        baseEndpointDnsNames.map(value => value),
        privateDnsName.map(value => value),
        privateDnsNameConfiguration.map(value => value.asEditable),
        payerResponsibility.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serviceType
        : Optional[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]]
    def serviceId: Optional[String]
    def serviceName: Optional[String]
    def serviceState: Optional[zio.aws.ec2.model.ServiceState]
    def availabilityZones: Optional[List[String]]
    def acceptanceRequired: Optional[Boolean]
    def managesVpcEndpoints: Optional[Boolean]
    def networkLoadBalancerArns: Optional[List[String]]
    def gatewayLoadBalancerArns: Optional[List[String]]
    def supportedIpAddressTypes
        : Optional[List[zio.aws.ec2.model.ServiceConnectivityType]]
    def baseEndpointDnsNames: Optional[List[String]]
    def privateDnsName: Optional[String]
    def privateDnsNameConfiguration
        : Optional[zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly]
    def payerResponsibility: Optional[zio.aws.ec2.model.PayerResponsibility]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getServiceType: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ServiceTypeDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceType", serviceType)
    def getServiceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceState: ZIO[Any, AwsError, zio.aws.ec2.model.ServiceState] =
      AwsError.unwrapOptionField("serviceState", serviceState)
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getManagesVpcEndpoints: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("managesVpcEndpoints", managesVpcEndpoints)
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("networkLoadBalancerArns", networkLoadBalancerArns)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("gatewayLoadBalancerArns", gatewayLoadBalancerArns)
    def getSupportedIpAddressTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ServiceConnectivityType]] =
      AwsError.unwrapOptionField(
        "supportedIpAddressTypes",
        supportedIpAddressTypes
      )
    def getBaseEndpointDnsNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("baseEndpointDnsNames", baseEndpointDnsNames)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getPrivateDnsNameConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "privateDnsNameConfiguration",
      privateDnsNameConfiguration
    )
    def getPayerResponsibility
        : ZIO[Any, AwsError, zio.aws.ec2.model.PayerResponsibility] =
      AwsError.unwrapOptionField("payerResponsibility", payerResponsibility)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ) extends zio.aws.ec2.model.ServiceConfiguration.ReadOnly {
    override val serviceType
        : Optional[List[zio.aws.ec2.model.ServiceTypeDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ServiceTypeDetail.wrap(item)
          }.toList
        )
    override val serviceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceId())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val serviceState: Optional[zio.aws.ec2.model.ServiceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceState())
        .map(value => zio.aws.ec2.model.ServiceState.wrap(value))
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val acceptanceRequired: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptanceRequired())
      .map(value => value: Boolean)
    override val managesVpcEndpoints: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.managesVpcEndpoints())
      .map(value => value: Boolean)
    override val networkLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val gatewayLoadBalancerArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gatewayLoadBalancerArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val supportedIpAddressTypes
        : Optional[List[zio.aws.ec2.model.ServiceConnectivityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedIpAddressTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ServiceConnectivityType.wrap(item)
          }.toList
        )
    override val baseEndpointDnsNames: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baseEndpointDnsNames())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val privateDnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateDnsName())
      .map(value => value: String)
    override val privateDnsNameConfiguration
        : Optional[zio.aws.ec2.model.PrivateDnsNameConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateDnsNameConfiguration())
        .map(value => zio.aws.ec2.model.PrivateDnsNameConfiguration.wrap(value))
    override val payerResponsibility
        : Optional[zio.aws.ec2.model.PayerResponsibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.payerResponsibility())
        .map(value => zio.aws.ec2.model.PayerResponsibility.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ServiceConfiguration
  ): zio.aws.ec2.model.ServiceConfiguration.ReadOnly = new Wrapper(impl)
}
