package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReplaceTransitGatewayRouteRequest(
    destinationCidrBlock: String,
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    blackhole: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest = {
    import ReplaceTransitGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest
      .builder()
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(blackhole.map(value => value: java.lang.Boolean))(
        _.blackhole
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest.wrap(buildAwsValue())
}
object ReplaceTransitGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest =
      zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest(
        destinationCidrBlock,
        transitGatewayRouteTableId,
        transitGatewayAttachmentId.map(value => value),
        blackhole.map(value => value)
      )
    def destinationCidrBlock: String
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def blackhole: Optional[Boolean]
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getBlackhole: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blackhole", blackhole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest
  ) extends zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val blackhole: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.blackhole())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceTransitGatewayRouteRequest
  ): zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
